<?php

/**
 * Settings for the Mykoob plugin
 *
 * @package    auth_mykoob
 * @author     Ilmars Poikans <ilmars.poikans@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

if (!defined('MOODLE_INTERNAL')) {
	die('Direct access to this script is forbidden.'); // It must be included from a Moodle page
}

require_once($CFG->dirroot . '/auth/mykoob/mykoob.php');
require_once($CFG->dirroot . '/auth/mykoob/mykoob_moodle.php');

$mykoob_config = get_config('auth_mykoob');

$mykoob_api = MykoobApi::createFromConfig($mykoob_config);

if ($mykoob_api) {
    $schools = $mykoob_api->listAuthorizedSchools()->authorized_schools->schools;
}

$settings->add(new admin_setting_heading('auth_mykob/connection_to_mykoob', get_string('config_connection_to_mykoob', 'auth_mykoob'),
                   get_string('config_connection_to_mykoob_description', 'auth_mykoob')));

$settings->add(new admin_setting_configtext('auth_mykoob/api_server', get_string('config_api_server', 'auth_mykoob'),
                   get_string('config_api_server_description', 'auth_mykoob'), 'https://www.mykoob.lv'));

$settings->add(new admin_setting_configtext('auth_mykoob/client_id', get_string('config_client_id', 'auth_mykoob'),
                   get_string('config_client_id_description', 'auth_mykoob'), ''));

$settings->add(new admin_setting_configtext('auth_mykoob/client_secret', get_string('config_client_secret', 'auth_mykoob'),
                   get_string('config_client_secret_description', 'auth_mykoob'), ''));

$settings->add(new admin_setting_configtext('auth_mykoob/callback_url', get_string('config_callback_url', 'auth_mykoob'),
                   get_string('config_callback_url_description', 'auth_mykoob'), $CFG->wwwroot . '/auth/mykoob/callback.php', PARAM_URL, 60));


$config_security_and_synchronization_description = get_string('config_security_and_synchronization_description', 'auth_mykoob') .
        '<a href="'. new moodle_url('/auth/mykoob/sync.php') . '">SYNC</a>';

$settings->add(new admin_setting_heading('auth_mykob/security_and_synchronization', get_string('config_security_and_synchronization', 'auth_mykoob'),
                   $config_security_and_synchronization_description));

$allowed_schools = $mykoob_config->schools_allowed;
$allowed_school_ids = empty($allowed_schools) ? array() : array_flip(explode(',', $allowed_schools));
unset($allowed_school_ids[0]); // 0 - error message, which can got saved, if user checks checkbox checked

$unknown_school = get_string('config_unknown_school', 'auth_mykoob');

$allowed_school_config_list = array();

if (isset($schools)) {

    $school_ids_to_process = $allowed_school_ids;

    foreach($schools as $school) {
        $allowed_school_config_list[$school->school_id] = ' [' . $school->school_id . '] ' . $school->name;
        unset($school_ids_to_process[$school->school_id]);
    }

    $missing_name = $unknown_school;

    if (empty($allowed_school_config_list)) {
        $school_ids_to_process[] = 0;
        $missing_name = get_string('config_no_schools_authorized', 'auth_mykoob');
    }

    foreach($school_ids_to_process as $school_id) {
        $allowed_school_config_list[$school_id] = ' [' . $school_id . '] ' . $missing_name;
    }

} else {

    $reload_page = get_string('config_reload_page', 'auth_mykoob');
    $missing_name = $unknown_school . ' ' . $reload_page;

    if (empty($allowed_school_ids)) {
        $allowed_school_ids[] = 0;
        $missing_name = get_string('config_failed_to_get_school_list', 'auth_mykoob');
    }

    foreach($allowed_school_ids as $allowed_school_id) {
        $allowed_school_config_list[$allowed_school_id] = ' [' . $allowed_school_id . '] ' . $missing_name;
    }
}

$settings->add(new admin_setting_configcheckbox('auth_mykoob/allow_any_user', get_string('config_allow_any_user', 'auth_mykoob'),
                   get_string('config_allow_any_user_description', 'auth_mykoob'), false));

$settings->add(new admin_setting_configmulticheckbox('auth_mykoob/schools_allowed', get_string('config_schools_allowed', 'auth_mykoob'),
                   get_string('config_schools_allowed_description', 'auth_mykoob'), array(), $allowed_school_config_list));

$settings->add(new admin_setting_configcheckbox('auth_mykoob/sync_users', get_string('config_sync_users', 'auth_mykoob'),
                   get_string('config_sync_users_description', 'auth_mykoob'), true));

// $settings->add(new admin_setting_configcheckbox('auth_mykoob/sync_during_next_cron', get_string('config_sync_during_next_cron', 'auth_mykoob'),
//                    get_string('config_sync_during_next_cron_description', 'auth_mykoob'), true));

$settings->add(new admin_setting_configtext('auth_mykoob/user_prefix', get_string('config_user_prefix', 'auth_mykoob'),
                   get_string('config_user_prefix_description', 'auth_mykoob'), 'mykoob_', PARAM_ALPHANUMEXT, 15));


$settings->add(new admin_setting_heading('auth_mykob/field_lock', get_string('config_field_locks', 'auth_mykoob'),
                   get_string('config_field_locks_description', 'auth_mykoob')));

$lockoptions = array ('locked'          => get_string('locked', 'auth'),
                      'unlockedifempty' => get_string('unlockedifempty', 'auth'),
                      'unlocked'        => get_string('unlocked', 'auth'));

$lockoptions_locked = array ('locked'   => get_string('locked', 'auth'));

$settings->add(new admin_setting_configselect('auth_mykoob/field_lock_email', get_string('email'), '', 'locked', $lockoptions));
$settings->add(new admin_setting_configselect('auth_mykoob/field_lock_firstname', get_string('firstname'), '', 'locked', $lockoptions));
$settings->add(new admin_setting_configselect('auth_mykoob/field_lock_lastname', get_string('lastname'), '', 'locked', $lockoptions));
$settings->add(new admin_setting_configselect('auth_mykoob/field_lock_country', get_string('country'), '', 'locked', $lockoptions));
$settings->add(new admin_setting_configselect('auth_mykoob/field_lock_city', get_string('city'), '', 'locked', $lockoptions));
$settings->add(new admin_setting_configselect('auth_mykoob/field_lock_idnumber', get_string('idnumber'), '', 'locked', $lockoptions_locked));

