<?php

/**
 * Get code, state and check for errors. If everything is right,
 * add authprovider parameter to identify the authentication provider and
 * redirect to the normal login page.
 *
 * @package    auth_mykoob
 * @author     Ilmars Poikans <ilmars.poikans@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../../config.php');

$code = optional_param('code', '', PARAM_TEXT);
$state = optional_param('state', '', PARAM_TEXT);

$error = optional_param('error', '', PARAM_TEXT);
$error_description = optional_param('error_description', '', PARAM_TEXT);

$loginurl = empty($CFG->alternateloginurl) ? '/login/index.php' : $CFG->alternateloginurl;

if ($state === 'syscheck') {
    redirect(new moodle_url('/auth/mykoob/syscheck.php'));
}

if (empty($code) && empty($error)) {
    throw new moodle_exception('error_nocallbackparams', 'auth_mykoob');
}

$params = empty($error) ? array('code' => $code, 'state' => $state, 'authprovider' => 'mykoob') : array();

$url = new moodle_url($loginurl, $params);

redirect($url);

