<?php

/**
 * Refresh data from Mykoob for setting up the Mykoob plugin
 *
 * @package    auth_mykoob
 * @author     Ilmars Poikans <ilmars.poikans@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->libdir.'/accesslib.php');
require_once($CFG->libdir.'/moodlelib.php');
require_once('mykoob_moodle.php');

$return_url = optional_param('return_url', '/', PARAM_TEXT);

require_login();
require_capability('moodle/site:config', get_context_instance(CONTEXT_SYSTEM));

$PAGE->set_url('/auth/mykoob/sync.php');
$PAGE->set_context(context_system::instance());

echo $OUTPUT->header();

echo $OUTPUT->box_start('generalbox boxaligncenter boxwidthwide');

echo $OUTPUT->heading(get_string('sync_mykoob_data_title', 'auth_mykoob'));

echo '<pre>';
MykoobMoodle::sync_all_schools();
echo MykoobMoodle::get_log();
echo '</pre>';

echo $OUTPUT->single_button($return_url, get_string('sync_mykoob_data_done', 'auth_mykoob'), 'post');

echo $OUTPUT->box_end();

echo $OUTPUT->footer();
