<?php

/**
 * Logout user from Mykoob system.
 *
 * @package    auth_mykoob
 * @author     Ilmars Poikans <ilmars.poikans@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../../config.php');
require_once('mykoob.php');

global $CFG;

$auth_mykoob_config = get_config('auth_mykoob');
$mykoob_api = MykoobApi::createFromConfig($auth_mykoob_config);

if (!$mykoob_api) {
    throw new moodle_exception('error_apinotconfigured', 'auth_mykoob');
}

$moodle_home_url = $CFG->wwwroot;
$mykoob_logout_url = $mykoob_api->getLogoutUrl(); // TODO: Add redirect to $moodle_home_url;

?>
<html>
<head>
  <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
  <meta http-equiv="refresh" content="5;url=<?php echo $moodle_home_url;?>" />
  <title>Atslēgšanās no Mykoob</title>
</head>
<body style="background: none repeat scroll 0 0 #FBFBFB;">
  <div style="margin: 200px auto; width: 700px;">
    <center>
      <table>
        <tr>
          <td align="center">
            <img src="pix/mykoob_logo.png"/><br />
            <h3>Atslēgšanās no Mykoob</h3>
            <hr/>
            <p>Lūdzu, uzgaidiet, kamēr Jūs tiksiet pāradresēts atpakaļ uz Moodle.</p>
            <p>Ja pāradresācija nenotiek automātiski, pagaidiet brīdi un klikšķiniet uz <a href="<?php echo $moodle_home_url; ?>">atpakaļ uz Moodle</a>.</p>
            <iframe src="<?php echo $mykoob_logout_url; ?>" width="0" height="0" scrolling="no" frameborder="0" ></iframe>
          </td>
        </tr>
      </table>
    </center>
  </div>
</body>
</html>