<?php

/**
 * Mykoob Authentication plugin
 *
 * @package    auth_mykoob
 * @author     Ilmars Poikans <ilmars.poikans@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

if (!defined('MOODLE_INTERNAL')) {
    die('Direct access to this script is forbidden.'); // It must be included from a Moodle page
}

/**
 * Custom function (Moodle doesn't call it) to get default config values
 * Used by install and upgrade functions.
 *
 * @return array of default config values
 */
function auth_mykoob_get_config_defaults() {

    global $CFG;

    $config_defaults = array();

    $config_defaults['api_server'] = 'https://www.mykoob.lv';
    $config_defaults['callback_url'] = $CFG->wwwroot . '/auth/mykoob/callback.php';
    $config_defaults['user_prefix'] = 'mykoob_';

    $config_defaults['allow_any_user'] = false;
    $config_defaults['schools_allowed'] = '';
    $config_defaults['sync_users'] = true;

    $config_defaults['field_lock_email'] = 'locked';
    $config_defaults['field_lock_firstname'] = 'locked';
    $config_defaults['field_lock_lastname'] = 'locked';
    $config_defaults['field_lock_country'] = 'locked';
    $config_defaults['field_lock_city'] = 'locked';
    $config_defaults['field_lock_idnumber'] = 'locked';

    return $config_defaults;
}

/**
 * Custom function (Moodle doesn't call it) to set default config values,
 * if they are not defined in config. Used by install and upgrade functions.
 */
function auth_mykoob_set_config_defaults() {

    $config = get_config('auth_mykoob');
    $config_defaults = auth_mykoob_get_config_defaults();

    foreach ($config_defaults as $key => $value) {
        if (!isset($config->$key))
            set_config($key, $value, 'auth_mykoob');
    }
}
